% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_vpc_endpoint}
\alias{ec2_modify_vpc_endpoint}
\title{Modify Vpc Endpoint}
\usage{
ec2_modify_vpc_endpoint(
  VpcEndpointId,
  DryRun = NULL,
  ResetPolicy = NULL,
  PolicyDocument = NULL,
  AddRouteTableId = NULL,
  RemoveRouteTableId = NULL,
  AddSubnetId = NULL,
  RemoveSubnetId = NULL,
  AddSecurityGroupId = NULL,
  RemoveSecurityGroupId = NULL,
  PrivateDnsEnabled = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{VpcEndpointId}{String. The ID of the endpoint.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{ResetPolicy}{Logical. (Gateway endpoint) Specify \code{true} to reset the policy document to the default policy.[optional]}

\item{PolicyDocument}{String. (Interface and gateway endpoints) A policy to attach to the endpoint that controls access to the...[optional]}

\item{AddRouteTableId}{List. (Gateway endpoint) One or more route tables IDs to associate with the endpoint.[optional]}

\item{RemoveRouteTableId}{List. (Gateway endpoint) One or more route table IDs to disassociate from the endpoint.[optional]}

\item{AddSubnetId}{List. (Interface and Gateway Load Balancer endpoints) One or more subnet IDs in which to serve the endpoint....[optional]}

\item{RemoveSubnetId}{List. (Interface endpoint) One or more subnets IDs in which to remove the endpoint.[optional]}

\item{AddSecurityGroupId}{List. (Interface endpoint) One or more security group IDs to associate with the network interface.[optional]}

\item{RemoveSecurityGroupId}{List. (Interface endpoint) One or more security group IDs to disassociate from the network interface.[optional]}

\item{PrivateDnsEnabled}{Logical. (Interface endpoint) Indicates whether a private hosted zone is associated with the VPC.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Modifies attributes of a specified VPC
endpoint. The attributes that you can modify depend on the type of VPC
endpoint (interface, gateway, or Gateway Load Balancer). For more
information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html}{VPC Endpoints}
in the \emph{Amazon Virtual Private Cloud User
Guide}.
}
\section{VpcEndpointId}{

The ID of the endpoint.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{ResetPolicy}{

(Gateway
endpoint) Specify \code{true} to reset the policy document to the default
policy. The default policy allows full access to the
service.
}

\section{PolicyDocument}{

(Interface and gateway endpoints) A policy
to attach to the endpoint that controls access to the service. The
policy must be in valid JSON format.
}

\section{AddRouteTableId}{

(Gateway
endpoint) One or more route tables IDs to associate with the
endpoint.
}

\section{RemoveRouteTableId}{

(Gateway endpoint) One or more route table
IDs to disassociate from the endpoint.
}

\section{AddSubnetId}{

(Interface
and Gateway Load Balancer endpoints) One or more subnet IDs in which to
serve the endpoint. For a Gateway Load Balancer endpoint, you can
specify only one subnet.
}

\section{RemoveSubnetId}{

(Interface endpoint) One or
more subnets IDs in which to remove the
endpoint.
}

\section{AddSecurityGroupId}{

(Interface endpoint) One or more security
group IDs to associate with the network
interface.
}

\section{RemoveSecurityGroupId}{

(Interface endpoint) One or more security
group IDs to disassociate from the network
interface.
}

\section{PrivateDnsEnabled}{

(Interface endpoint) Indicates whether a
private hosted zone is associated with the VPC.
}

