% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_get_reserved_instances_exchange_quote}
\alias{ec2_get_reserved_instances_exchange_quote}
\title{Get Reserved Instances Exchange Quote}
\usage{
ec2_get_reserved_instances_exchange_quote(
  ReservedInstanceId,
  DryRun = NULL,
  TargetConfiguration = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{ReservedInstanceId}{List. The IDs of the Convertible Reserved Instances to exchange.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{TargetConfiguration}{List. The configuration of the target Convertible Reserved Instance to exchange for your current Convertible...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Returns a quote and exchange information for
exchanging one or more specified Convertible Reserved Instances for a
new Convertible Reserved Instance. If the exchange cannot be performed,
the reason is returned in the response. Use
AcceptReservedInstancesExchangeQuote to perform the
exchange.
}
\section{ReservedInstanceId}{

The IDs of the Convertible
Reserved Instances to exchange.
}

\section{DryRun}{

Checks whether you
have the required permissions for the action, without actually making
the request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{TargetConfiguration}{

The configuration of the
target Convertible Reserved Instance to exchange for your current
Convertible Reserved Instances.
}

