% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_regions}
\alias{ec2_describe_regions}
\title{Describe Regions}
\usage{
ec2_describe_regions(
  Filter = NULL,
  RegionName = NULL,
  DryRun = NULL,
  AllRegions = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{RegionName}{List. The names of the Regions.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{AllRegions}{Logical. Indicates whether to display all Regions, including Regions that are disabled for your account.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describe Regions
}
\section{Filter}{


The filters.
\itemize{
\item \code{endpoint} - The endpoint of the Region (for example,
\verb{ec2.us-east-1.amazonaws.com}).
\item \verb{opt-in-status} - The opt-in status of the Region
(\verb{opt-in-not-required} \| \verb{opted-in} \| \verb{not-opted-in}).
\item \code{region-name} - The name of the Region (for example, \code{us-east-1}).
}
}

\section{RegionName}{

The names of the Regions. You can specify any
Regions, whether they are enabled and disabled for your
account.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{AllRegions}{

Indicates whether to
display all Regions, including Regions that are disabled for your
account.
}

