% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_image_attribute}
\alias{ec2_describe_image_attribute}
\title{Describe Image Attribute}
\usage{
ec2_describe_image_attribute(
  Attribute,
  ImageId,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{Attribute}{String.   The AMI attribute.}

\item{ImageId}{String. The ID of the AMI.}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes the specified attribute of the specified
AMI. You can specify only one attribute at a time.
}
\section{Attribute}{


The AMI attribute.

\strong{Note}: The \code{blockDeviceMapping} attribute is deprecated. Using this
attribute returns the \code{Client.AuthFailure} error. To get information
about the block device mappings for an AMI, use the DescribeImages
action.
}

\section{ImageId}{

The ID of the AMI.
}

\section{DryRun}{

Checks
whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

