% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_allocate_hosts}
\alias{ec2_allocate_hosts}
\title{Allocate Hosts}
\usage{
ec2_allocate_hosts(
  AvailabilityZone,
  Quantity,
  AutoPlacement = NULL,
  ClientToken = NULL,
  InstanceType = NULL,
  InstanceFamily = NULL,
  TagSpecification = NULL,
  HostRecovery = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{AvailabilityZone}{String. The Availability Zone in which to allocate the Dedicated Host.}

\item{Quantity}{Integer. The number of Dedicated Hosts to allocate to your account with these parameters.}

\item{AutoPlacement}{String.   Indicates whether the host accepts any untargeted instance launches that match its instance type...[optional]}

\item{ClientToken}{String. Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.[optional]}

\item{InstanceType}{String.   Specifies the instance type to be supported by the Dedicated Hosts.[optional]}

\item{InstanceFamily}{String.   Specifies the instance family to be supported by the Dedicated Hosts.[optional]}

\item{TagSpecification}{List. The tags to apply to the Dedicated Host during creation.[optional]}

\item{HostRecovery}{String.   Indicates whether to enable or disable host recovery for the Dedicated Host.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Allocates a Dedicated Host to your account. At a
minimum, specify the supported instance type or instance family, the
Availability Zone in which to allocate the host, and the number of hosts
to allocate.
}
\section{AvailabilityZone}{

The Availability Zone in which
to allocate the Dedicated Host.
}

\section{Quantity}{

The number of
Dedicated Hosts to allocate to your account with these
parameters.
}

\section{AutoPlacement}{


Indicates whether the host accepts any untargeted instance launches that
match its instance type configuration, or if it only accepts Host
tenancy instance launches that specify its unique host ID. For more
information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding}{Understanding auto-placement and affinity}
in the \emph{Amazon EC2 User Guide}.

Default: \code{on}
}

\section{ClientToken}{

Unique, case-sensitive identifier that you provide
to ensure the idempotency of the request. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.
}

\section{InstanceType}{


Specifies the instance type to be supported by the Dedicated Hosts. If
you specify an instance type, the Dedicated Hosts support instances of
the specified instance type only.

If you want the Dedicated Hosts to support multiple instance types in a
specific instance family, omit this parameter and specify
\strong{InstanceFamily} instead. You cannot specify \strong{InstanceType} and
\strong{InstanceFamily} in the same request.
}

\section{InstanceFamily}{


Specifies the instance family to be supported by the Dedicated Hosts. If
you specify an instance family, the Dedicated Hosts support multiple
instance types within that instance family.

If you want the Dedicated Hosts to support a specific instance type
only, omit this parameter and specify \strong{InstanceType} instead. You
cannot specify \strong{InstanceFamily} and \strong{InstanceType} in the same
request.
}

\section{TagSpecification}{

The tags to apply to the Dedicated Host during
creation.
}

\section{HostRecovery}{


Indicates whether to enable or disable host recovery for the Dedicated
Host. Host recovery is disabled by default. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html}{Host recovery}
in the \emph{Amazon EC2 User Guide}.

Default: \code{off}
}

