% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm_detect_trend.R
\name{stsm_detect_trend}
\alias{stsm_detect_trend}
\title{Detect trend type}
\usage{
stsm_detect_trend(
  y,
  freq,
  decomp = "",
  sig_level = 0.01,
  prior = NULL,
  seasons = NULL,
  cycle = NULL,
  cl = NULL,
  cores = NULL,
  verbose = FALSE
)
}
\arguments{
\item{y}{Univariate time series of data values. May also be a 2 column data frame containing a date column.}

\item{freq}{Frequency of the data (1 (yearly), 4 (quarterly), 12 (monthly), 365.25/7 (weekly), 365.25 (daily))}

\item{decomp}{Decomposition model ("tend-cycle-seasonal", "trend-seasonal", "trend-cycle", "trend-noise")}

\item{sig_level}{Significance level to determine statistically significant seasonal frequencies}

\item{prior}{A data table created by stsm_prior}

\item{seasons}{The seasonal periods}

\item{cycle}{The cycle period}

\item{cl}{a parallel cluster object}

\item{cores}{Number of cores to use}

\item{verbose}{Logical whether to print messages or not}
}
\value{
list with trend type and logical flag for deterministic trend if the trend is determined to have 0 differencing
}
\description{
Detect trend type
}
\examples{
\dontrun{
#GDP Not seasonally adjusted
library(autostsm)
data("NA000334Q", package = "autostsm") #From FRED
NA000334Q = data.table(NA000334Q, keep.rownames = TRUE)
colnames(NA000334Q) = c("date", "y")
NA000334Q[, "date" := as.Date(date)]
NA000334Q[, "y" := as.numeric(y)]
NA000334Q = NA000334Q[date >= "1990-01-01", ]
trend = stsm_detect_trend(y = NA000334Q$y, freq = 4)
}
}
