% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centeredGradient.R
\name{centeredLogLikGrad}
\alias{centeredLogLikGrad}
\title{Centered model gradient}
\usage{
centeredLogLikGrad(theta, X, z, A, constraint, thetaInds, innerIndices = NULL)
}
\arguments{
\item{theta}{a matrix of coefficients with dimension (p+(k-1)*length(A)) by k; frequently A will have length 1}

\item{X}{nxp design matrix}

\item{z}{nxk response matrix}

\item{A}{a list of adjacency matrices}

\item{constraint}{constraint on eta}

\item{thetaInds}{relevant indices}

\item{innerIndices}{only here to match argument list with uncentered case}
}
\value{
a gradient vector
}
\description{
Computes a gradient for the centered model, taking coefficients, a design matrix, a response matrix, and a list of adjacency matrices
}
\examples{
#g=centeredLogLikGrad(theta,X,z,A)
}
\keyword{centered,}
\keyword{gradient}

