% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialNodes.R
\name{spatialNodes}
\alias{spatialNodes}
\title{Using an autocart model, use the terminal nodes to form a spatial process that uses inverse
distance weighting to interpolate. The prediction for the new data that is passed in is formed
by making a prediction to assign it to a group. Next, the residual for the new prediction is
formed by inverse distance weighting the residual for the other points that are a part of that geometry.}
\usage{
spatialNodes(
  autocartModel,
  newdata,
  newdataCoords,
  method = "idw",
  distpower = 2,
  distpowerRange = c(0, 2),
  modelByResidual = TRUE,
  decideByGC = FALSE
)
}
\arguments{
\item{autocartModel}{an autocart model returned from the \code{autocart} function.}

\item{newdata}{a dataframe that contains the same predictors that were used to form the tree.}

\item{newdataCoords}{a matrix of coordinates for all the predictors contained in \code{newdata}}

\item{method}{The type of interpolation to use. Options are "idw" for inverse distance weighting and "tps" for thin-plate splines.}

\item{distpower}{the power to use if you would like to use something other than straight inverse distance, such as inverse distance squared.}

\item{distpowerRange}{A range of distpower to use. This is an adaptive inverse distance weighting method that linearly matches measures of spatial autocorrelation measured by Moran I to the range mentioned in distpower.}

\item{modelByResidual}{If true, then predict using the average of the "spatial node", and then model the residual using a spatial process. If false, fit a spatial process directly.}

\item{decideByGC}{When determining if a spatial process should be ran at a terminal node, should we use the Geary C statistic instead of Moran I?}
}
\value{
a prediction for the observations that are represented by \code{newdata} and \code{newdataCoords}
}
\description{
Using an autocart model, use the terminal nodes to form a spatial process that uses inverse
distance weighting to interpolate. The prediction for the new data that is passed in is formed
by making a prediction to assign it to a group. Next, the residual for the new prediction is
formed by inverse distance weighting the residual for the other points that are a part of that geometry.
}
\examples{
# Load some data for a spatial nodes example
snow <- na.omit(read.csv(system.file("extdata", "ut2017_snow.csv", package = "autocart")))
y <- snow$yr50[1:40]
X <- data.frame(snow$ELEVATION, snow$MCMT, snow$PPTWT, snow$HUC)[1:40, ]
locations <- as.matrix(cbind(snow$LONGITUDE, snow$LATITUDE))[1:40, ]

# Create an autocart model
snow_model <- autocart(y, X, locations, 0.30, 0)

# Predit with the spatial node effect
new_X <- X[1:10, ]
new_loc <- locations[1:10, ]
spatial_node_predictions <- spatialNodes(snow_model, new_X, new_loc, distpowerRange = c(0, 2))

}
