% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summary.autoMrP}
\alias{summary.autoMrP}
\title{A summary method for autoMrP objects.}
\usage{
\method{summary}{autoMrP}(
  object,
  ci.lvl = 0.95,
  digits = 4,
  format = "simple",
  classifiers = NULL,
  n = 10,
  ...
)
}
\arguments{
\item{object}{An \code{autoMrP()} object for which a summary is desired.}

\item{ci.lvl}{The level of the confidence intervals. A proportion. Default is
\code{0.95}. Confidence intervals are based on bootstrapped estimates and
will not be printed if bootstrapping was not carried out.}

\item{digits}{The number of digits to be displayed. An integer scalar.
Default is \code{4}.}

\item{format}{The table format. A character string passed to
\code{\link[knitr]{kable}}. Default is \code{simple}.}

\item{classifiers}{Summarize a single classifier. A character string. Must be
one of \code{best_subset}, \code{lasso}, \code{pca}, \code{gb}, \code{svm},
or \code{mrp}. Default is \code{NULL}.}

\item{n}{Number of rows to be printed. An integer scalar. Default is
\code{10}.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
No return value, prints a summary of the context level preference
 estimates to the console.
}
\description{
\code{summary.autoMrP()} ...
}
