% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vbmfa.R
\name{vbmfa}
\alias{vbmfa}
\title{Variational Bayesian Mixture of Factor Analyzers (VB-MoFA)}
\usage{
vbmfa(Y, qmax = NULL, maxtries = 3, verbose = FALSE, varimax = FALSE)
}
\arguments{
\item{Y}{An \emph{n} by \emph{p} (normalised) data matrix (i.e. the result of
a call to the function \code{preprocess}), where \emph{n} is the number of observations and
\emph{p} is the number of dimensions of the data.}

\item{qmax}{Maximum factor dimensionality (default \emph{p}-1).}

\item{maxtries}{The maximum number of times the algorithm will attempt to split each component.}

\item{verbose}{Whether or not verbose output should be printed during the
model fitting process (defaults to false).}

\item{varimax}{Boolean indicating whether the output factor loading matrices should be constrained
using varimax rotation or not.}
}
\value{
A list containing the following elements:
\itemize{
\item{\code{model}:}{ A list specifying the final MFA model. This contains: \itemize{
\item{\code{B}:}{ A \emph{p} by \emph{p} by \emph{q} array containing the factor loading matrices for each component.}
\item{\code{D}:}{ A \emph{p} by \emph{p} by \emph{g} array of error variance matrices.}
\item{\code{mu}:}{  A \emph{p} by \emph{g} array containing the mean of each cluster.}
\item{\code{pivec}:}{ A 1 by \emph{g} vector containing the mixing
proportions for each FA in the mixture.}
\item{\code{numFactors}:}{ A 1 by \emph{g} vector containing the number of factors for each FA.}}
}
\item{\code{clustering}:}{ A list specifying the clustering produced by the final model. This contains: \itemize{
\item{\code{responsibilities}:}{ A \emph{n} by \emph{g} matrix containing the probability
that each point belongs to each FA in the mixture.}
\item{\code{allocations}:}{ A \emph{n} by 1 matrix containing which
FA in the mixture each point is assigned to based on the responsibilities.}}}
\item{\code{diagnostics}:}{ A list containing various pieces of information related to the fitting process of the algorithm. This contains: \itemize{
\item{\code{bic}:}{ The BIC of the final model.}
\item{\code{logL}:}{ The log-likelihood of the final model.}
\item{\code{Fhist}:}{The values of \emph{F} at each iteration of the algorithm. \emph{F} is defined in \insertCite{ghahramani2000variational}{autoMFA}.}
\item{\code{times}:}{ The time taken for each loop in the algorithm.}
\item{\code{totalTime}:}{ The total time taken to fit the final model.}}}
}
}
\description{
An implementation of the Variational Bayesian Mixutre of Factor
Analysers \insertCite{ghahramani2000variational}{autoMFA}. This code is an
R port of the MATLAB code which was written by M.J.Beal and released alongside
their paper.
}
\examples{
RNGversion('4.0.3'); set.seed(3)
Yout <- preprocess(MFA_testdata)
MFA.fit <- vbmfa(Yout$Yout, maxtries = 2)

}
\references{
\insertRef{ghahramani2000variational}{autoMFA}
}
\seealso{
\code{\link{preprocess}} for centering and scaling data prior to using \code{vbmfa}.
}
