% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-observer.R
\name{auk_observer}
\alias{auk_observer}
\title{Filter the eBird data by observer}
\usage{
auk_observer(x, observer_id)
}
\arguments{
\item{x}{\code{auk_ebd} or \code{auk_sampling} object; reference to file created by
\code{\link[=auk_ebd]{auk_ebd()}} or \code{\link[=auk_sampling]{auk_sampling()}}.}

\item{observer_id}{character or integer; observers to filter by. Observer IDs
can be provided either as integer (e.g. 12345) or character with the "obsr"
prefix as they appear in the EBD (e.g. "obsr12345").}
}
\value{
An \code{auk_ebd} or `auk_sampling`` object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) based on a set of
observer IDs This function only defines the filter and, once all filters have
been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and perform the
filtering.
}
\examples{
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_observer("obsr313215")
  
# alternatively, without pipes
ebd <- auk_ebd(system.file("extdata/ebd-sample.txt", package = "auk"))
auk_observer(ebd, observer = 313215)
}
\seealso{
Other filter: \code{\link{auk_bbox}},
  \code{\link{auk_bcr}}, \code{\link{auk_breeding}},
  \code{\link{auk_complete}}, \code{\link{auk_country}},
  \code{\link{auk_date}}, \code{\link{auk_distance}},
  \code{\link{auk_duration}}, \code{\link{auk_extent}},
  \code{\link{auk_filter}}, \code{\link{auk_last_edited}},
  \code{\link{auk_project}}, \code{\link{auk_protocol}},
  \code{\link{auk_species}}, \code{\link{auk_state}},
  \code{\link{auk_time}}
}
\concept{filter}
