% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-rollup.r
\name{auk_rollup}
\alias{auk_rollup}
\title{Roll up eBird taxonomy to species}
\usage{
auk_rollup(x)
}
\arguments{
\item{x}{data.frame; data frame of eBird data, typically as imported by
\code{\link[=read_ebd]{read_ebd()}}}
}
\value{
A data frame of the eBird data with taxonomic rollup applied.
}
\description{
The eBird Basic Dataset (EBD) includes both true species and other taxa,
including domestics, hybrids, subspecies, "spuhs", and recognizable forms.
In some cases, a checklist may contain multiple records for the same species,
for example, both Audubon and Myrtle Yellow-rumped Warblers, as well as some
records that are not resolvable to species, for example, "warbler sp.".
This function addresses these cases by removing taxa not identifiable to
species and rolling up taxa identified below species level to a single record
for each species in each checklist. By default, \code{\link[=read_ebd]{read_ebd()}} calls
\code{ebd_rollup()} when importing an eBird data file.
}
\details{
When rolling observations up to species level the observed counts
are summed across any taxa that resolve to the same species. However, if
any of these taxa have a count of "X" (i.e. the observer did not enter a
count), then the rolled up record will get an "X" as well. For example, if
an observer saw 3 Myrtle and 2 Audubon Warblers, this will roll up to 5
Yellow-rumped Warblers. However, if an "X" was entered for Myrtle, this
would roll up to "X" for Yellow-rumped Warbler.
}
\examples{
f <- system.file("extdata/ebd-rollup-ex.txt", package = "auk")
read_ebd(f, rollup = FALSE)
}
