% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_renv.R
\name{create_renv_for_dev}
\alias{create_renv_for_dev}
\alias{create_renv_for_prod}
\title{Create reproducible environments for your R projects with {renv}}
\usage{
create_renv_for_dev(
  path = ".",
  dev_pkg = "_default",
  folder_to_include = c("dev", "data-raw"),
  output = "renv.lock",
  install_if_missing = TRUE,
  document = TRUE,
  pkg_ignore = NULL,
  ...
)

create_renv_for_prod(
  path = ".",
  output = "renv.lock.prod",
  dev_pkg = "remotes",
  ...
)
}
\arguments{
\item{path}{Path to your current package source folder}

\item{dev_pkg}{Vector of packages you need for development. Use \verb{_default}
(with underscore before to avoid confusing with a package name), to
use the default list. Use \code{NULL} for no extra package.
Use \code{attachment:::extra_dev_pkg} for the list.}

\item{folder_to_include}{Folder to scan to detect development packages}

\item{output}{Path and name of the file created, default is \code{./renv.lock}}

\item{install_if_missing}{Logical. Install missing packages. \code{TRUE} by default}

\item{document}{Logical. Whether to run \code{\link[=att_amend_desc]{att_amend_desc()}} before
detecting packages in DESCRIPTION.}

\item{pkg_ignore}{Vector of packages to ignore from being discovered in your files.
This does not prevent them to be in "renv.lock" if they are recursive dependencies.}

\item{...}{Other arguments to pass to \code{\link[renv:snapshot]{renv::snapshot()}}}
}
\value{
a renv.lock file
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Tool to create and maintain renv.lock files.
The idea is to have 2 distinct files, one for development and the other for deployment.
Indeed, although packages like {attachment} or {pkgload} must be installed to develop,
they are not necessary in your project, package or Shiny application.
}
\examples{
\dontrun{
create_renv_for_dev()
create_renv_for_dev(dev_pkg = "attachment")
create_renv_for_prod()
}
}
