% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SwordDataverseClient.R
\docType{class}
\name{SwordDataverseClient}
\alias{SwordDataverseClient}
\title{SWORD Dataverse client class}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an Sword Dataverse-specific APIclient
}
\description{
This class models an Sword service Dataverse-specific  API client
}
\details{
SwordDataverseClient
}
\examples{
\dontrun{
   #connect to SWORD Dataverse API
   SWORD <- SwordDataverseClient$new(
     hostname = "localhost:8085",
     token = "<token>",
     logger = "DEBUG"
   )

   #for detailed operations check the wiki at:
   #https://github.com/eblondel/atom4R/wiki#atom4R-publish-sword-dataverse
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{API}
\keyword{Client}
\keyword{Dataverse}
\keyword{SWORD}
\section{Super classes}{
\code{\link[atom4R:atom4RLogger]{atom4R::atom4RLogger}} -> \code{\link[atom4R:AtomPubClient]{atom4R::AtomPubClient}} -> \code{\link[atom4R:SwordClient]{atom4R::SwordClient}} -> \code{SwordDataverseClient}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SwordDataverseClient-new}{\code{SwordDataverseClient$new()}}
\item \href{#method-SwordDataverseClient-getServiceDocument}{\code{SwordDataverseClient$getServiceDocument()}}
\item \href{#method-SwordDataverseClient-getCollectionMembers}{\code{SwordDataverseClient$getCollectionMembers()}}
\item \href{#method-SwordDataverseClient-getDataverses}{\code{SwordDataverseClient$getDataverses()}}
\item \href{#method-SwordDataverseClient-getDataverse}{\code{SwordDataverseClient$getDataverse()}}
\item \href{#method-SwordDataverseClient-editDataverseEntry}{\code{SwordDataverseClient$editDataverseEntry()}}
\item \href{#method-SwordDataverseClient-getDataverseRecord}{\code{SwordDataverseClient$getDataverseRecord()}}
\item \href{#method-SwordDataverseClient-createDataverseRecord}{\code{SwordDataverseClient$createDataverseRecord()}}
\item \href{#method-SwordDataverseClient-updateDataverseRecord}{\code{SwordDataverseClient$updateDataverseRecord()}}
\item \href{#method-SwordDataverseClient-deleteDataverseRecord}{\code{SwordDataverseClient$deleteDataverseRecord()}}
\item \href{#method-SwordDataverseClient-publishDataverseRecord}{\code{SwordDataverseClient$publishDataverseRecord()}}
\item \href{#method-SwordDataverseClient-addFilesToDataverseRecord}{\code{SwordDataverseClient$addFilesToDataverseRecord()}}
\item \href{#method-SwordDataverseClient-deleteFilesFromDataverseRecord}{\code{SwordDataverseClient$deleteFilesFromDataverseRecord()}}
\item \href{#method-SwordDataverseClient-clone}{\code{SwordDataverseClient$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="ERROR"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-ERROR'><code>atom4R::atom4RLogger$ERROR()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="INFO"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-INFO'><code>atom4R::atom4RLogger$INFO()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="WARN"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-WARN'><code>atom4R::atom4RLogger$WARN()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="getClass"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-getClass'><code>atom4R::atom4RLogger$getClass()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="getClassName"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-getClassName'><code>atom4R::atom4RLogger$getClassName()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="logger"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-logger'><code>atom4R::atom4RLogger$logger()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomPubClient" data-id="getPwd"><a href='../../atom4R/html/AtomPubClient.html#method-AtomPubClient-getPwd'><code>atom4R::AtomPubClient$getPwd()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomPubClient" data-id="getToken"><a href='../../atom4R/html/AtomPubClient.html#method-AtomPubClient-getToken'><code>atom4R::AtomPubClient$getToken()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomPubClient" data-id="getUser"><a href='../../atom4R/html/AtomPubClient.html#method-AtomPubClient-getUser'><code>atom4R::AtomPubClient$getUser()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomPubClient" data-id="listCollections"><a href='../../atom4R/html/AtomPubClient.html#method-AtomPubClient-listCollections'><code>atom4R::AtomPubClient$listCollections()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordDataverseClient-new"></a>}}
\if{latex}{\out{\hypertarget{method-SwordDataverseClient-new}{}}}
\subsection{Method \code{new()}}{
This method is to instantiate an Sword API Dataverse-specific Client.

   The \code{keyring_backend} can be set to use a different backend for storing
   the SWORD DataVerse API user token with \pkg{keyring} (Default value is 'env').

   The \code{logger} allows to specify the level of log (default is NULL), either "INFO"
   for \pkg{atom4R} logs or "DEBUG" for verbose HTTP client (curl) logs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordDataverseClient$new(
  hostname,
  token = NULL,
  logger = NULL,
  keyring_backend = "env"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{hostname}}{host name}

\item{\code{token}}{token}

\item{\code{logger}}{logger}

\item{\code{keyring_backend}}{keyring backend. Default is 'env'}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordDataverseClient-getServiceDocument"></a>}}
\if{latex}{\out{\hypertarget{method-SwordDataverseClient-getServiceDocument}{}}}
\subsection{Method \code{getServiceDocument()}}{
Get service document
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordDataverseClient$getServiceDocument(force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{force}}{force Force getting/refreshing of service document}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
object of class \link{SwordServiceDocument}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordDataverseClient-getCollectionMembers"></a>}}
\if{latex}{\out{\hypertarget{method-SwordDataverseClient-getCollectionMembers}{}}}
\subsection{Method \code{getCollectionMembers()}}{
Get collection members
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordDataverseClient$getCollectionMembers(collectionId)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{collectionId}}{collection ID}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list of \link{AtomFeed}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordDataverseClient-getDataverses"></a>}}
\if{latex}{\out{\hypertarget{method-SwordDataverseClient-getDataverses}{}}}
\subsection{Method \code{getDataverses()}}{
Get dataverses. Equivalent to \code{listCollections()} from \link{AtomPubClient}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordDataverseClient$getDataverses(pretty = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pretty}}{prettify output as \code{data.frame}. Default is \code{FALSE}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \code{data.frame}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordDataverseClient-getDataverse"></a>}}
\if{latex}{\out{\hypertarget{method-SwordDataverseClient-getDataverse}{}}}
\subsection{Method \code{getDataverse()}}{
Get dataverse members by dataverse name. Equivlaent to \code{getCollectionMembers()}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordDataverseClient$getDataverse(dataverse)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataverse}}{dataverse name}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a list of \link{AtomFeed}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordDataverseClient-editDataverseEntry"></a>}}
\if{latex}{\out{\hypertarget{method-SwordDataverseClient-editDataverseEntry}{}}}
\subsection{Method \code{editDataverseEntry()}}{
Edits a dataverse entry
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordDataverseClient$editDataverseEntry(identifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{identifier}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{AtomEntry}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordDataverseClient-getDataverseRecord"></a>}}
\if{latex}{\out{\hypertarget{method-SwordDataverseClient-getDataverseRecord}{}}}
\subsection{Method \code{getDataverseRecord()}}{
Get dataverse record
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordDataverseClient$getDataverseRecord(identifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{identifier}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{AtomFeed}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordDataverseClient-createDataverseRecord"></a>}}
\if{latex}{\out{\hypertarget{method-SwordDataverseClient-createDataverseRecord}{}}}
\subsection{Method \code{createDataverseRecord()}}{
Creates a dataverse record
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordDataverseClient$createDataverseRecord(dataverse, entry)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataverse}}{dataverse name}

\item{\code{entry}}{entry}

\item{\code{the}}{created \link{AtomEntry}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordDataverseClient-updateDataverseRecord"></a>}}
\if{latex}{\out{\hypertarget{method-SwordDataverseClient-updateDataverseRecord}{}}}
\subsection{Method \code{updateDataverseRecord()}}{
Updates a dataverse record
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordDataverseClient$updateDataverseRecord(dataverse, entry, identifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataverse}}{dataverse name}

\item{\code{entry}}{entry}

\item{\code{identifier}}{identifier of the entry to update}

\item{\code{the}}{created \link{AtomEntry}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordDataverseClient-deleteDataverseRecord"></a>}}
\if{latex}{\out{\hypertarget{method-SwordDataverseClient-deleteDataverseRecord}{}}}
\subsection{Method \code{deleteDataverseRecord()}}{
Deletes a dataverse record
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordDataverseClient$deleteDataverseRecord(identifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{identifier}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, or returns an error otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordDataverseClient-publishDataverseRecord"></a>}}
\if{latex}{\out{\hypertarget{method-SwordDataverseClient-publishDataverseRecord}{}}}
\subsection{Method \code{publishDataverseRecord()}}{
Publishes a dataverse record
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordDataverseClient$publishDataverseRecord(identifier)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{identifier}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the published \link{AtomEntry}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordDataverseClient-addFilesToDataverseRecord"></a>}}
\if{latex}{\out{\hypertarget{method-SwordDataverseClient-addFilesToDataverseRecord}{}}}
\subsection{Method \code{addFilesToDataverseRecord()}}{
Add files to a dataverse record
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordDataverseClient$addFilesToDataverseRecord(identifier, files)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{identifier}

\item{\code{files}}{files}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordDataverseClient-deleteFilesFromDataverseRecord"></a>}}
\if{latex}{\out{\hypertarget{method-SwordDataverseClient-deleteFilesFromDataverseRecord}{}}}
\subsection{Method \code{deleteFilesFromDataverseRecord()}}{
Deletes files from a Dataverse record
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordDataverseClient$deleteFilesFromDataverseRecord(identifier, files = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{identifier}}{identifier}

\item{\code{files}}{files}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \code{data.frame} giving each file and it's deletion status
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordDataverseClient-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SwordDataverseClient-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordDataverseClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
