% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-nc-physics.R
\name{load_nc_physics}
\alias{load_nc_physics}
\title{Load Atlantis outputfiles (netcdf)}
\usage{
load_nc_physics(nc, select_physics, prm_run, bboxes, aggregate_layers = FALSE,
  warn_zeros = FALSE)
}
\arguments{
\item{nc}{Character string giving the connection of the netcdf file to read in.
The filename usually contains \code{output} and ends in \code{.nc}".}

\item{select_physics}{Character vector of physical variables which shall be read in.
Names have to match the ones used in the ncdf file.}

\item{prm_run}{Character string giving the connection of the run parameterfile.
The filename usually contains \code{run_fishing} and ends in \code{.prm}".}

\item{bboxes}{Integer vector giving the box-id of the boundary boxes.
Can be created with \code{get_boundary}.}

\item{aggregate_layers}{Logical indicating if values for layers should be
aggregated (\code{TRUE}) or not (\code{FALSE}). Default is \code{FALSE}.}

\item{warn_zeros}{Logical indicating if check for actual zeros in the
data shall be printed or not. Default is \code{FALSE}.}
}
\value{
A \code{data.frame} in long format with the following column names:
  variable, time, polygon, layer, and atoutput (i.e., variable).
}
\description{
This function loads Atlantis outputfiles (netcdf) and converts them to a dataframe.
}
\details{
This functions converts the ATLANTIS output to a dataframe which can be processed in R.
}
\examples{
d <- system.file("extdata", "setas-model-new-becdev", package = "atlantistools")
nc <- file.path(d, "outputSETAS.nc")
prm_run <- file.path(d, "VMPA_setas_run_fishing_F_New.prm")
bboxes <- get_boundary(boxinfo = load_box(file.path(d, bgm = "VMPA_setas.bgm")))
select_physics <- c("salt", "NO3", "volume")

test <- load_nc_physics(nc, select_physics, prm_run, bboxes)
str(test)

d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
nc <- file.path(d, "outputSETAS.nc")
prm_run <- file.path(d, "VMPA_setas_run_fishing_F_Trunk.prm")
bboxes <- get_boundary(boxinfo = load_box(file.path(d, bgm = "VMPA_setas.bgm")))

test <- load_nc_physics(nc, select_physics, prm_run, bboxes)
str(test)

test <- load_nc_physics(nc, select_physics = "nominal_dz", prm_run, bboxes)
}
\seealso{
Other load functions: \code{\link{load_box}},
  \code{\link{load_bps}}, \code{\link{load_dietcheck}},
  \code{\link{load_fgs}}, \code{\link{load_init_age}},
  \code{\link{load_init}}, \code{\link{load_nc}},
  \code{\link{load_rec}}, \code{\link{load_spec_mort}},
  \code{\link{load_txt}}
}
\keyword{gen}
