% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atable_compact.R
\name{atable_compact}
\alias{atable_compact}
\alias{atable_compact.data.frame}
\title{More compact formatting than atable()}
\usage{
atable_compact(x, ...)

\method{atable_compact}{data.frame}(
  x,
  target_cols,
  group_col = NULL,
  indent_character = atable_options("indent_character_compact"),
  blocks = NULL,
  format_factor = atable_options("format_statistics_compact.statistics_factor"),
  format_numeric = atable_options("format_statistics_compact.statistics_numeric"),
  ...
)
}
\arguments{
\item{x}{object passed to atable.}

\item{...}{Passed to \code{\link{atable}}.}

\item{target_cols}{character. Some of colnames(x).}

\item{group_col}{character or NULL. If character then, one of colnames(x).}

\item{indent_character}{character length 1. Default is defined in table_options("indent_character_compact").
For Latex-Format use e.g. \code{indent_character="\\quad"}.
For Word-Format use e.g. \code{indent_character=paste0(rep(intToUtf8(160), 5), collapse = "")} and e.g.
Package officer and its functions officer::read_docx(), officer::body_add_table and print-methods.}

\item{blocks}{NULL or a list, passed to atable, see help there.}

\item{format_factor}{a function that defines the format of factor variables.
Default is defined in \code{\link{atable_options}}. See \code{\link{check_format_statistics}} for the return-value of this function.}

\item{format_numeric}{a function that defines the format of numeric variables.
Analog to format_factor.}
}
\value{
data.frame
}
\description{
This is a wrapper for atable(), calculating the same statistics, but with different format.
}
\details{
The compact formatting is:

Numeric target_cols get one line in the table; the line contains the mean and SD of the variable.

Factor target_cols also get one line in the table, when they have only two levels and only the first level
is displayed in the table and the name of the variable is omitted. This is intended for item like "Sex at birth: Female/Male".
Knowing the percentage of Female is sufficient in this case (when NAs are not counted).
Be careful with items like "Pregnant: Yes/No".
Here only the level "Yes" will be printed and the name of the item (Pregnant) is omitted, making the table uninformative.
Factors with three or more levels get one line per level, the levels are intended and a header line
containing the name of the variable is added.

Arguments in ... are passed to \code{\link{atable}}. See the help there.
\code{atable_compact} is not designed for splitted atables, so argument \code{split_cols} must be omitted or NULL.
Also argument \code{format_to} is ignored.
Other features of atable (blocking, add_margins, alias) are available, see examples.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: a compact version of atable.
}}

\examples{
# For Console:
atable_compact(
  atable::test_data,
  target_cols = c("Numeric", "Numeric2", "Split2", "Factor", "Ordered"),
  group_col = "Group2",
  blocks = list("Primary Endpoint" = "Numeric",
                "Secondary Endpoints" = c("Numeric2", "Split2", "Factor")),
  add_margins = TRUE)

# The target_cols are "Numeric", "Numeric2", "Split2", "Factor", "Ordered".
# The group_col is "Group2".
# The data.frame is grouped by group_col and the summary statistcs of the target_cols are
# calculated: mean, sd for numeric, counts and percentages for factors.
# Some target_cols are blocked: the first block 'Primary Endpoint' contains the variable Numeric.
# The second block 'Secondary  Endpoint' contains the variables "Numeric2", "Split2", "Factor".
# The blocks are intended.
# For variable Split2 only the first level is reported, as the variable has only two levels and
# the name 'Split2' does not appear in the table.
# The variable Factor has more than two levels, so all of them are
# reported and appropriately intended.
# The variable Ordered is not part of a block and thus not intended.

# For Latex:
# Same as for Console, but with different indent_character:

tab = atable_compact(atable::test_data,
                     target_cols = c("Numeric", "Numeric2", "Logical", "Factor", "Ordered"),
                     group_col = "Group2",
                     indent_character = "\\\\quad")

tab = atable::translate_to_LaTeX(tab)

# Then call e.g. Hmisc::latex(tab, ...)


# Example for Word format:
\dontrun{
tab = atable_compact(
  atable::test_data,
  target_cols = c("Numeric", "Numeric2", "Split2", "Factor", "Ordered", "Character"),
  group_col = "Group2",
  blocks = list("Primary Endpoint" = "Numeric",
                "Secondary Endpoints" = c("Numeric2", "Split2", "Factor")),
  add_margins = TRUE,
  indent_character = paste0(rep(intToUtf8(160), 5), collapse = ""))

# The argument indent_character has the value intToUtf8(160) (non breakable space).
# This is the important part:
# Spaces at the beginning of a cell of a data.frame are somehow lost on the way to the docx.
# Other indent_characters may also do the job.

# doc = officer::read_docx()
# doc = officer::body_add_table(doc,tab)

# print(doc, target = "atable_Word.docx")

# Other packages may exist for Word-export.
}


}
