% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_plot_distrib_3D.R
\name{f_plot_distrib_3D}
\alias{f_plot_distrib_3D}
\title{Plot of historical distributions in 3D}
\usage{
f_plot_distrib_3D(
  m_param_histo,
  type_function,
  database,
  n_samples,
  x_min,
  x_max,
  x_lab,
  y_lab
)
}
\arguments{
\item{m_param_histo}{Numeric matrix containing the parameters of the f_param_histo function}

\item{type_function}{String argument specifying the distribution type ("gaussian" or "skew-t")}

\item{database}{Dataframe containing the data, with dates in the first column and dependent variable in the second column}

\item{n_samples}{Number optional of samples for the plot (default value = 1000)}

\item{x_min}{Numeric optional argument (default value = -15)}

\item{x_max}{Numeric optional argument (default value = 10)}

\item{x_lab}{String optional argument for the x axis title (default value = x)}

\item{y_lab}{String optional argument for the y axis title (default value = y)}
}
\value{
A plot in 3D of historical distributions
}
\description{
This function allows to create a plot in 3D of historical distributions.
}
\examples{
# Import data
data(data_US)

data(data_param_histo)

results_plot_3D <- f_plot_distrib_3D(m_param_histo=data_param_histo,
type_function="skew-t",
database=data_US,
x_lab="US GDP variation",
y_lab="Year")

}
