% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assertions.R
\name{insist_rows}
\alias{insist_rows}
\alias{insist_rows_}
\title{Raises error if dynamically created predicate is FALSE for any row
after applying row reduction function}
\usage{
insist_rows(data, row_reduction_fn, predicate_generator, ...,
  error_fun = assertr_stop)

insist_rows_(data, row_reduction_fn, predicate_generator, ..., .dots,
  error_fun = assertr_stop, .nameofpred = "")
}
\arguments{
\item{data}{A data frame}

\item{row_reduction_fn}{A function that returns a value for each row of
the provided data frame}

\item{predicate_generator}{A function that is applied to the results of
the row reduction function. This will produce,
a true predicate function to be applied to every
element in the vector that the row reduction
function returns.}

\item{...}{Comma separated list of unquoted expressions.
Uses dplyr's \code{select} to select
columns from data.}

\item{error_fun}{Function to call if assertion fails. Takes one error
string. Uses \code{stop} by default}

\item{.dots}{Use insist_rows_() to select columns using standard evaluation.}

\item{.nameofpred}{Text representation of predicate for printing in case
        of assertion violation. Will automatically be retrieved if left
        blank (default)}
}
\value{
data if dynamically created predicate assertion is TRUE. error if not.
}
\description{
Meant for use in a data analysis pipeline, this function applies a
function to a data frame that reduces each row to a single value. Then,
a predicate generating function is applied to row reduction values. It will
then use these predicates to check each of the row reduction values. If any
of these predicate applications yield FALSE, this function will raise
an error, effectively terminating the pipeline early. If there are no
FALSEs, this function will just return the data that it was supplied for
further use in later parts of the pipeline.
}
\note{
See \code{vignette("assertr")} for how to use this in context
}
\examples{
# returns mtcars
insist_rows(mtcars, maha_dist, within_n_mads(30), mpg:carb)

# equivalent using standard evaluation
insist_rows_(mtcars, maha_dist, within_n_mads(30), "mpg:carb")


library(magrittr)                    # for piping operator

mtcars \%>\%
  insist_rows(maha_dist, within_n_mads(10), vs:am)
  # anything here will run

\dontrun{
mtcars \%>\%
  insist_rows(maha_dist, within_n_mads(1), everything())
  # the assertion is untrue so
  # nothing here will run}
}
\seealso{
\code{\link{insist}} \code{\link{assert_rows}}
         \code{\link{assert}} \code{\link{verify}}
}

