% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assert-is-type-dplyr.R, R/is-type-dplyr.R
\name{assert_is_tbl}
\alias{assert_is_tbl}
\alias{assert_is_tbl_cube}
\alias{assert_is_tbl_df}
\alias{assert_is_tbl_dt}
\alias{is_tbl}
\alias{is_tbl_cube}
\alias{is_tbl_df}
\alias{is_tbl_dt}
\title{Is the input a tbl?}
\usage{
assert_is_tbl(x, severity = getOption("assertive.severity", "stop"))

assert_is_tbl_cube(x, severity = getOption("assertive.severity", "stop"))

assert_is_tbl_df(x, severity = getOption("assertive.severity", "stop"))

assert_is_tbl_dt(x, severity = getOption("assertive.severity", "stop"))

is_tbl(x, .xname = get_name_in_parent(x))

is_tbl_cube(x, .xname = get_name_in_parent(x))

is_tbl_df(x, .xname = get_name_in_parent(x))

is_tbl_dt(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_data.table} wraps \code{is.data.table}, providing more
information on failure. The \code{assert_*} functions return nothing but
throws an error if the corresponding \code{is_*} function returns
\code{FALSE}.
}
\description{
Checks to see if the input is a tbl.
}
\examples{
if(requireNamespace("dplyr"))
{
  assert_is_tbl_df(dplyr::tbl_df(data.frame(x = 1:5)))
  #These examples should fail.
  assertive.base::dont_stop(assert_is_tbl(data.frame(x = 1:5)))
} else
{
  message("This example requires the data.table package to be installed.")
}
}
\seealso{
\code{\link[data.table]{is.data.table}}.
}

