% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engine.R
\name{assert_engine}
\alias{assert_engine}
\title{Throws an error if a condition isn't met}
\usage{
assert_engine(predicate, ..., msg = "The assertion failed.", what = c("all",
  "any"), na_ignore = FALSE, severity = c("stop", "warning", "message",
  "none"))
}
\arguments{
\item{predicate}{Function that returns a logical value (possibly 
a vector).}

\item{...}{Passed to the \code{predicate} function.}

\item{msg}{The error message, in the event of failure.}

\item{what}{Either 'all' or 'any', to reduce vectorised tests to a 
single value.}

\item{na_ignore}{A logical value.  If \code{FALSE}, \code{NA} values
cause an error; otherwise they do not.  Like \code{na.rm} in many
stats package functions, except that the position of the failing
values does not change.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}
}
\value{
\code{FALSE} with the attribute \code{message}, as provided
in the input.
}
\description{
The workhorse of the package.  If a condition isn't met, then an error
is thrown.  This function is exported for use by package developers so
that they can create their own assert functions.
}
\note{
Missing values are considered as \code{FALSE} for the purposes of
whether or not an error is thrown.
}

