% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_variable.R
\name{input_variable}
\alias{input_variable}
\alias{dataset}
\title{Input variables}
\usage{
input_variable(name)

dataset(path, use_only_filename = FALSE)
}
\arguments{
\item{name}{Variable name}

\item{path}{Dataset path}

\item{use_only_filename}{Whether to include the path of the file}
}
\value{
A building block of type 'input_variable'
}
\description{
These building block declare input variables, i.e., variables that are defined in the dataset.
}
\details{
An input variable is defined in the dataset and is declared so that it can be used in the rest of the model definition. The function
\code{input_variable()} declares a single variable whereas the \code{dataset()} function reads the header of the file provided and
declares all variables found.
}
\examples{
m <- model() +
    input_variable("dose") +
    prm_log_normal("emax") +
    prm_log_normal("ed50") +
    obs_additive(eff~emax*dose/(ed50+dose))
render(m)
}
