% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAlgoPerfADoc.R,
%   R/plotAlgoPerfBoxplots.R, R/plotAlgoPerfCDFs.R, R/plotAlgoPerfDensities.R,
%   R/plotAlgoPerfScatterMatrix.R
\name{plotAlgoPerf}
\alias{plotAlgoPerf}
\alias{plotAlgoPerfBoxplots}
\alias{plotAlgoPerfCDFs}
\alias{plotAlgoPerfDensities}
\alias{plotAlgoPerfScatterMatrix}
\title{EDA plots for performance values of algorithms across all instances.}
\usage{
plotAlgoPerfBoxplots(
  asscenario,
  measure,
  impute.zero.vals = FALSE,
  log = FALSE,
  impute.failed.runs = TRUE,
  rm.censored.runs = TRUE
)

plotAlgoPerfCDFs(
  asscenario,
  measure,
  impute.zero.vals = FALSE,
  log = FALSE,
  rm.censored.runs = TRUE
)

plotAlgoPerfDensities(
  asscenario,
  measure,
  impute.failed.runs = TRUE,
  impute.zero.vals = FALSE,
  log = FALSE,
  rm.censored.runs = TRUE
)

plotAlgoPerfScatterMatrix(
  asscenario,
  measure,
  impute.zero.vals = FALSE,
  log = FALSE,
  rm.censored.runs = TRUE
)
}
\arguments{
\item{asscenario}{[\code{\link{ASScenario}}]\cr
Algorithm selection scenario.}

\item{measure}{[\code{character(1)}]\cr
Measure to plot.
Default is first measure in scenario.}

\item{impute.zero.vals}{[\code{logical(1)}]\cr
Should values which are exactly 0 be imputed to 1e-6?
This allows to take the logarithm later on, handy for subsequent visualizations.
Note that this really only makes sense for non-negative measures!
Default is FALSE.}

\item{log}{[\code{logical(1)}]\cr
Should the performance values be log10-transformed in the plot?
Default is FALSE.}

\item{impute.failed.runs}{[\code{logical(1)}]\cr
Should runtimes for failed runs be imputed?
Default is TRUE.}

\item{rm.censored.runs}{[\code{logical(1)}]\cr
Should runtimes for censored runs (i.e. runs that have hitted the walltime) be
removed (and eventually be imputed along with the remaining NAs)?
Default is TRUE.}
}
\value{
ggplot2 plot object.
}
\description{
If NAs occur, they are imputed (before aggregation) by
\code{base + 0.3 range + jitter} .
\code{base} is is the cutoff value for runtimes scenarios with cutoff or
the worst performance for all others.

For the CDFs we only show the visible area where successful runs occurred.

Stochastic replications are aggregated by the mean value.
}
