% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAlgoCorMatrix.R
\name{plotAlgoCorMatrix}
\alias{plotAlgoCorMatrix}
\title{Plots the correlation matrix of the algorithms.}
\usage{
plotAlgoCorMatrix(
  asscenario,
  measure,
  order.method = "hclust",
  hclust.method = "ward.D2",
  cor.method = "spearman"
)
}
\arguments{
\item{asscenario}{[\code{\link{ASScenario}}]\cr
Algorithm selection scenario.}

\item{measure}{[\code{character(1)}]\cr
Measure to plot.
Default is first measure in scenario.}

\item{order.method}{[\code{character(1)}]\cr
Method for ordering the algorithms within the plot.
Possible values are \dQuote{hclust} (for hierarchical clustering order),
\dQuote{FPC} (first principal component order), \dQuote{AOE} (angular order
of eigenvectors), \dQuote{original} (original order) and \dQuote{alphabet}
(alphabetical order).
See \code{\link[corrplot]{corrMatOrder}}.
Default is \dQuote{hclust}.}

\item{hclust.method}{[\code{character(1)}]\cr
Method for hierarchical clustering. Only useful, when \code{order.method}
is set to \dQuote{hclust}, otherwise ignored.
Possible values are: \dQuote{ward.D2}, \dQuote{single},
\dQuote{complete}, \dQuote{average}, \dQuote{mcquitty}, \dQuote{median} and
\dQuote{centroid}.
See \code{\link[corrplot]{corrMatOrder}}.
Default is \dQuote{ward.D2}.}

\item{cor.method}{[\code{character(1)}]\cr
Method to be used for calculating the correlation between the algorithms.
Possible values are \dQuote{pearson}, \dQuote{kendall} and \dQuote{spearman}.
See \code{\link{cor}}.
Default is \dQuote{spearman}.}
}
\value{
See \code{\link[corrplot]{corrplot}}.
}
\description{
If NAs occur, they are imputed (before aggregation) by
\code{base + 0.3 * range}.
\code{base} is the cutoff value for runtimes scenarios with cutoff or
the worst performance for all others.

Stochastic replications are aggregated by the mean value.
}
