% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitr.R
\name{init_knitr_engine}
\alias{init_knitr_engine}
\title{Initialize the asciicast knitr engine}
\usage{
init_knitr_engine(
  echo = FALSE,
  same_process = TRUE,
  timeout = 10,
  startup = NULL,
  record_env = NULL,
  echo_input = TRUE,
  options = list()
)
}
\arguments{
\item{echo}{Whether to print the code of asciicast chunks.}

\item{same_process}{Whether to run all asciicast chunks \emph{in the same}
R process. To restart this R process, call \code{init_knitr_engine()}
again.}

\item{timeout}{Idle timeout, in seconds If the R subprocess running
the recording does not answer within this limit, it is killed and the
recording stops.}

\item{startup}{Quoted language object to run in the subprocess before
starting the recording.}

\item{record_env}{Environment variables to set for the R subprocess.}

\item{echo_input}{Whether to echo the input in the asciicast recording.}

\item{options}{R options to set (via the \code{R.options} chunk option of
knitr), in the current R process that performs the recording.
See \code{\link[=asciicast_knitr_options]{asciicast_knitr_options()}} for the defaults.}
}
\description{
Call this function in your Rmd file to enable creating asciinema
casts from code chunks.
}
\details{
\subsection{Limitations}{
\itemize{
\item \code{purl()} or setting the \code{purl = TRUE} chunk option, does not work
properly, in that knitr thinks that asciicast chunks are not R code,
so they will appear as comments. If you know how to fix this, please
contact us.
}
}
}
\section{Examples}{

Call this function from an Rmd chunk and then you can use the asciicast
knitr engine:

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{r setup, include = FALSE\}
asciicast::init_knitr_engine()
```
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{asciicast, cache = TRUE\}`
#' Rows: 10
# This is an asciicast example
loadedNamespaces()
```
}\if{html}{\out{</div>}}
}

\seealso{
Other asciicast in Rmd: 
\code{\link{asciicast_knitr_options}()}
}
\concept{asciicast in Rmd}
