% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelsum.control.R
\name{modelsum.control}
\alias{modelsum.control}
\title{Control settings for \code{modelsum} function}
\usage{
modelsum.control(digits = 3, nsmall = NULL, nsmall.ratio = 2,
  digits.test = 3, show.adjust = TRUE, show.intercept = TRUE,
  conf.level = 0.95, binomial.stats = c("OR", "CI.lower.OR", "CI.upper.OR",
  "p.value", "concordance", "Nmiss"), gaussian.stats = c("estimate",
  "std.error", "p.value", "adj.r.squared", "Nmiss"), poisson.stats = c("RR",
  "CI.lower.RR", "CI.upper.RR", "p.value", "concordance", "Nmiss"),
  survival.stats = c("HR", "CI.lower.HR", "CI.upper.HR", "p.value",
  "concordance", "Nmiss"), ...)
}
\arguments{
\item{digits}{Numeric, denoting the number of significant digits for beta coefficients and standard errors.}

\item{nsmall}{Numeric, denoting the number of digits after the decimal point for beta coefficients and standard errors.}

\item{nsmall.ratio}{Numeric, denoting the number of digits after the decimal point for ratios, e.g. OR, RR, HR.}

\item{digits.test}{Numeric, denoting the number of significant digits for p-values.}

\item{show.adjust}{Logical, denoting whether to show adjustment terms.}

\item{show.intercept}{Logical, denoting whether to show intercept terms.}

\item{conf.level}{Numeric, giving the confidence level.}

\item{binomial.stats, survival.stats, gaussian.stats, poisson.stats}{Character vectors denoting which stats to show for the various model types.}

\item{...}{Other arguments (not in use at this time).}
}
\value{
A list with settings to be used within the \code{modelsum} function.
}
\description{
Control test and summary settings for \code{\link{modelsum}} function.
}
\seealso{
\code{\link{modelsum}}, \code{\link{summary.modelsum}}
}

