% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aricode.R
\name{MARI}
\alias{MARI}
\title{Modified Adjusted Rand Index}
\usage{
MARI(c1, c2)
}
\arguments{
\item{c1}{a vector containing the labels of the first classification. Must be a vector of characters, integers, numerics, or a factor, but not a list.}

\item{c2}{a vector containing the labels of the second classification.}
}
\value{
a scalar with the modified ARI.
}
\description{
A function to compute a modified adjusted rand index between two classifications as proposed by Sundqvist et al. in prep, based on a multinomial model.
}
\examples{
data(iris)
cl <- cutree(hclust(dist(iris[,-5])), 4)
MARI(cl,iris$Species)
}
\seealso{
\code{\link{ARI}}, \code{\link{NID}}, \code{\link{NVI}}, \code{\link{NMI}}, \code{\link{clustComp}}
}
