% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/shinySearchInLocalRepo.R
\name{shinySearchInLocalRepo}
\alias{shinySearchInLocalRepo}
\title{Shiny Based Live Search for an Artifact in a Repository Using Tags}
\usage{
shinySearchInLocalRepo(repoDir = NULL, host = "0.0.0.0")
}
\arguments{
\item{repoDir}{A character denoting an existing directory in which artifacts will be searched.
If set to \code{NULL} (by default), uses the \code{repoDir} specified in \link{setLocalRepo}.}

\item{host}{A host IP adress, see the \code{host} argument in \code{shiny::runApp}.}
}
\value{
\code{shinySearchInLocalRepo} runs a shiny application.
}
\description{
\code{shinySearchInLocalRepo} searches for an artifact in a \link{Repository} using \link{Tags}.
To create an application one needs to point the name of artifacts repository.
The application is generated on the fly. Right now two controllers are exposed.
A text input field and a slider. Tags that are typed into text field are used for searching in repository.
Object that have same tags are then presented on right panel.
These object might be also downloaded just by click.
To learn more about artifacts visit \link[archivist]{archivist-package}.
}
\details{
\code{shinySearchInLocalRepo} searches for artifacts in a Repository using their's \code{Tag}
(e.g., \code{name}, \code{class} or \code{archiving date}). \code{Tags} are submitted in a
text input in a shiny application. Many tags may be specified, they should be comma separated.
User can specify more tags when artifact is created, tags like phase, project, author etc.

In the search query one can add tags started with sort: or sort:-
then miniatures will be sorted accordingly.
For exaple sort:class will sort along class tag, while sort:-class backward.
sort:createdDate will sort along createdDate and sort:-createdDate backward.

\code{Tags}, submitted in the text field, should be given according to the
format: \code{"TagType:TagTypeValue"} - see examples.
}
\examples{
\dontrun{
  # assuming that there is a 'repo' dir with a valid archivist repository
  shinySearchInLocalRepo( dir = 'repo' )
}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{ahistory}},
  \code{\link{print.ahistory}};
  \code{\link{archivist-package}}; \code{\link{aread}};
  \code{\link{asearch}}; \code{\link{cache}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveSetToRepo}};
  \code{\link{saveToRepo}}; \code{\link{setGithubRepo}},
  \code{\link{setLocalRepo}}; \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}};
  \code{\link{zipGithubRepo}}, \code{\link{zipLocalRepo}}
}

