##    archivist package for R
##
#' @title Tools for storing, restoring and searching for R objects
#'
#' @description
#' Data exploration and modelling is a process in which a lot of data artifacts are produced. 
#' Artifacts like: subsets, data aggregates, plots, statistical models, different
#' versions of data sets and different versions of results. 
#' The more projects we work with the more artifacts are produced and the harder it is to manage these artifacts. 
#' 
#' Archivist helps to store and manage artifacts created in R.
#' 
#' Archivist allows you to store selected artifacts as a binary files
#'   together with their metadata and relations.
#' Archivist allows to share artifacts with others, either through shared folder or github.
#' Archivist allows to look for already created artifacts by using it's class, 
#'   name, date of the creation or other attributes, properties or meta-tags.
#' Makes it easy to restore such artifacts.
#' Archivist allows to check if new artifact is the exact 
#'   copy that was produced some time ago.
#'   That might be useful either for testing or caching.
#'   
#'
#'
#' @details
#' For more detailed information visit \pkg{archivist} \code{wiki} on 
#' \href{https://github.com/pbiecek/archivist/wiki}{Github}.
#'
#' @author
#' Przemyslaw Biecek [aut, cre] \email{przemyslaw.biecek@@gmail.com} \cr
#' Marcin Kosinski [aut] \email{m.p.kosinski@@gmail.com}
#' 
#' @import RCurl
#' @import httr
#' @import RSQLite
#' @import DBI
#' @import jsonlite
#' @import lubridate
#' @import digest
#' @family archivist
#' @name archivist-package
#' @docType package
invisible(NULL)
