% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soilColorSignature.R
\name{soilColorSignature}
\alias{soilColorSignature}
\title{Soil Profile Color Signatures}
\usage{
soilColorSignature(
  spc,
  r = "r",
  g = "g",
  b = "b",
  method = "colorBucket",
  pam.k = 3,
  RescaleLightnessBy = 1,
  useProportions = TRUE,
  pigmentNames = c(".white.pigment", ".red.pigment", ".green.pigment",
    ".yellow.pigment", ".blue.pigment")
)
}
\arguments{
\item{spc}{a \code{SoilProfileCollection} object}

\item{r}{horizon level attribute containing soil color (sRGB) red values}

\item{g}{horizon level attribute containing soil color (sRGB) green values}

\item{b}{horizon level attribute containing soil color (sRGB) blue values}

\item{method}{algorithm used to compute color signature, \code{colorBucket}, \code{depthSlices}, or \code{pam}}

\item{pam.k}{number of classes to request from \code{cluster::pam()}}

\item{RescaleLightnessBy}{rescaling factor for CIE LAB L-coordinate}

\item{useProportions}{use proportions or quantities, see details}

\item{pigmentNames}{names for resulting pigment proportions or quantities}
}
\value{
For the \code{colorBucket} method, a \code{data.frame} object containing:
\itemize{
\item id column: set according to \code{idname(spc)}
\item \code{.white.pigment}: proportion or quantity of CIE LAB L-values
\item \code{.red.pigment}: proportion or quantity of CIE LAB positive A-values
\item \code{.green.pigment}: proportion or quantity of CIE LAB negative A-values
\item \code{.yellow.pigment}: proportion or quantity of CIE LAB positive B-values
\item \code{.blue.pigment}: proportion or quantity of CIE LAB negative B-values
}

Column names can be adjusted with the \code{pigmentNames} argument.

For the \code{depthSlices} method ...

For the \code{pam} method ...
}
\description{
Generate a color signature for each soil profile in a collection.
}
\details{
See the \href{http://ncss-tech.github.io/AQP/aqp/soil-color-signatures.html}{related tutorial}.
}
\examples{

# trivial example, not very interesting
data(sp1)
depths(sp1) <- id ~ top + bottom

# convert Munsell -> sRGB triplets
rgb.data <- munsell2rgb(sp1$hue, sp1$value, sp1$chroma, return_triplets = TRUE)
sp1$r <- rgb.data$r
sp1$g <- rgb.data$g
sp1$b <- rgb.data$b

# extract color signature
pig <- soilColorSignature(sp1)

}
\references{
https://en.wikipedia.org/wiki/Lab_color_space
}
\seealso{
\code{\link{munsell2rgb}}
}
\author{
D.E. Beaudette
}
