% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hzBoundary.R
\name{hzDistinctnessCodeToOffset}
\alias{hzDistinctnessCodeToOffset}
\title{Convert Horizon Boundary Distinctness to Vertical Offset}
\usage{
hzDistinctnessCodeToOffset(
  x,
  codes = c("V", "A", "C", "G", "D"),
  offset = c(0.5, 2, 5, 15, 20)/2
)
}
\arguments{
\item{x}{vector of boundary distinctness codes to be converted}

\item{codes}{code values, adjust as needed}

\item{offset}{vertical offset factors (cm), approximating 1/2 of the transitional zone thickness, see details}
}
\value{
vector of offsets with same length as \code{x}
}
\description{
This function will convert USDA-NCSS horizon boundary distinctness codes into vertical (+/-) offsets in cm, based on the \href{https://www.nrcs.usda.gov/wps/portal/nrcs/detail/soils/research/guide/?cid=nrcs142p2_054184}{Field Book for Describing and Sampling Soils, version 3.0}.
}
\details{
The default offests are based on the high-end of ranges presented in "transitional zone thickness criteria" from the Field Book version 3.0 (page 2-6). Offsets are returned as 1/2 of the transitional zone thickness so that horizon boundaries can be adjusted up/down from horizon depths. See \code{\link{plotSPC}}, specifically the \code{hz.distinctness.offset} argument for vizualization ideas. Missing data in \code{x} (NA) or codes that are not defined in \code{codes} are returned as 0 offsets.
}
\examples{
data(sp1)
hzDistinctnessCodeToOffset(sp1$bound_distinct)

}
\references{
\href{https://www.nrcs.usda.gov/wps/portal/nrcs/detail/soils/research/guide/?cid=nrcs142p2_054184}{Field Book for Describing and Sampling Soils, version 3.0}
}
\seealso{
\code{\link{plotSPC}}
}
\author{
D.E. Beaudette
}
\keyword{manip}
