% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols.rgr.R
\name{ols.rgr}
\alias{ols.rgr}
\title{Linear Regression using Ordinary Least Squares}
\usage{
ols.rgr(dataset)
}
\arguments{
\item{dataset}{a \code{p} x \code{m} data matrix, where the final column
is a continuous outcome variable. \code{datashape} may be applied to data
so that the dataset is in the correct format for this function (see manual)}
}
\value{
the function returns a column-vector containing the
        linear regression coefficients.
}
\description{
Fit a linear regression model using Ordinary Least Squares.
}
\details{
This function may be called directly. For regression with an intercept included,
the first column in the dataset must be a column of 1s.
}
\examples{
## Linear regression using a subset of the mtcars data (outcome is "wt")
data(mtcars)
mtc.df <- mtcars[, c(6, 1, 4)]
mtc.shaped <- datashape(dataset = mtc.df, y = 1)
ols.rgr(mtc.shaped)
ols.rgr(cbind(1,mtc.shaped))
}

