% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_insertOLList.R
\name{apollo_insertOLList}
\alias{apollo_insertOLList}
\title{Replaces \code{tau=c(...)} by \code{tau=list(...)} in calls to \code{apollo_ol}}
\usage{
apollo_insertOLList(f)
}
\arguments{
\item{f}{Function. Usually \code{apollo_probabilities}, 
\code{apollo_randCoeff}, or \code{apollo_lcPars}.}
}
\value{
Function \code{f} with \code{tau=c(...)} replaced by 
        \code{tau=list(...)}.
}
\description{
Takes a function, looks for calls to apollo_ol, identifies the corresponding
ol_settings, then goes inside the definition of ol_settings and replaces
\code{tau=c(...)} for \code{tau=list(...)}.
}
\details{
This only goes one level deep in definitions. For example, it will work
correctly in the following cases:
\code{
ol_settings = list(outcomeOrdered = y1, 
                   V   = b1*x1, 
                   tau = c(tau11, tau12))
P[["OL1"]] = apollo_ol(ol_settings, functionality)
P[["OL2"]] = apollo_ol(list(outcomeOrdered=y2, V=b2*x2, tau=c(tau21, tau22)),
                       functionality)
}
But it will not work on the following cases:
\code{
Tau = c(tau1, tau2, tau3)
ol_settings = list(outcomeOrdered = y2,
                   V = b2*x2, 
                   tau = Tau)
P[["OL1"]] = apollo_ol(ol_settings, functionality)
P[["OL2"]] = apollo_ol(list(outcomeOrdered=y1, V=b1*x1, tau=Tau), functionality)
}

This function is called by apollo_modifyUserDefFunc to allow for analytical
gradients when using apollo_ol.
}
