% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_makeCluster.R
\name{apollo_makeCluster}
\alias{apollo_makeCluster}
\title{Creates cluster for estimation.}
\usage{
apollo_makeCluster(apollo_probabilities, apollo_inputs, silent = FALSE)
}
\arguments{
\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive three arguments:
\itemize{
  \item apollo_beta: Named numeric vector. Names and values of model parameters.
  \item apollo_inputs: List containing options of the model. See \link{apollo_validateInputs}.
  \item functionality: Character. Can be either "estimate" (default), "prediction", "validate", "conditionals", "zero_LL", or "raw".
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{silent}{Boolean. If TRUE, it reports progress to the console. Default is FALSE.}
}
\value{
Cluster (i.e. an object of class cluster from package parallel)
}
\description{
Creates cluster and loads pieces of the database for each worker.
}
\details{
Internal use only. Called by \code{apollo_estimate} before estimation. AT least doubles up memory usage. But during the splitting it uses even more (~250% of the original).
}
