% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surplus.R
\name{surplus}
\alias{surplus}
\title{Compute economic surplus}
\usage{
surplus(x, timeStep = "annual", synthesis = FALSE,
  groupByDistrict = FALSE, hurdleCost = TRUE, opts = NULL)
}
\arguments{
\item{x}{an object of class "antaresDataList" created with the function
\code{readAntares}. It has to contain some areas and all the links that are
connected to these areas. Moreover it needs to have a hourly time step and detailed results.}

\item{timeStep}{Desired time step for the result.}

\item{synthesis}{If TRUE, average surpluses are returned. Else the function returns surpluses
per Monte-Carlo scenario.}

\item{groupByDistrict}{If TRUE, results are grouped by district.}

\item{hurdleCost}{If TRUE, HURDLE COST will be removed from congestionFees.}

\item{opts}{opts}
}
\value{
A data.table with the following columns:
\item{area}{Name of the area.}
\item{timeId}{timeId and other time columns.}
\item{consumerSurplus}{The surplus of the consumers of some area.

                     formula = (unsupliedCost[area] - `MRG. PRICE`) * LOAD}
\item{producerSurplus}{
  The surplus of the producers of some area.

  formula = `MRG. PRICE` * production - `OP. COST`

  Production includes "NUCLEAR", "LIGNITE", "COAL", "GAS", "OIL", "MIX. FUEL",
  "MISC. DTG", "H. STOR", "H. ROR", "WIND", "SOLAR" and "MISC. NDG"
}
\item{rowBalanceSurplus}{
  Surplus of the ROW balance.

  Formula: `MRG. PRICE` * `ROW BAL.`
}
\item{storageSurplus}{
  Surplus created by storage/flexibility areas.

  formula = storage * x$areas$`MRG. PRICE`
}
\item{congestionFees}{
  The congestion fees of a given area. It equals to half
  the congestion fees of the links connected to that area.

  formula = (congestionFees-hurdleCost) / 2
 }
\item{globalSurplus}{
  Sum of the consumer surplus, the producer surplus and the congestion fees.

  formula = consumerSurplus + producerSurplus + storageSurplus + congestionFees + rowBalanceSurplus}
}
\description{
This function computes the economic surplus for the consumers, the producers
and the global surplus of an area.
}
\examples{
\dontrun{
showAliases("surplus")

mydata <- readAntares(select="surplus")
surplus(mydata)

surplus(mydata, synthesis = TRUE)
surplus(mydata, synthesis = TRUE, groupByDistrict = TRUE)
}

}
