% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scenarioBuilder.R
\name{scenario-builder}
\alias{scenario-builder}
\alias{scenarioBuilder}
\alias{readScenarioBuilder}
\alias{updateScenarioBuilder}
\alias{clearScenarioBuilder}
\alias{deduplicateScenarioBuilder}
\title{Read, create, update & deduplicate scenario builder}
\usage{
scenarioBuilder(
  n_scenario,
  n_mc = NULL,
  areas = NULL,
  areas_rand = NULL,
  coef_hydro_levels = NULL,
  opts = antaresRead::simOptions()
)

readScenarioBuilder(
  ruleset = "Default Ruleset",
  as_matrix = TRUE,
  opts = antaresRead::simOptions()
)

updateScenarioBuilder(
  ldata,
  ruleset = "Default Ruleset",
  series = NULL,
  clusters_areas = NULL,
  links = NULL,
  opts = antaresRead::simOptions()
)

clearScenarioBuilder(
  ruleset = "Default Ruleset",
  opts = antaresRead::simOptions()
)

deduplicateScenarioBuilder(
  ruleset = "Default Ruleset",
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{n_scenario}{Number of scenario.}

\item{n_mc}{Number of Monte-Carlo years.}

\item{areas}{Areas to use in scenario builder, if \code{NULL} (default) all areas in Antares study are used.}

\item{areas_rand}{Areas for which to use \code{"rand"}.}

\item{coef_hydro_levels}{Hydro levels coefficients.}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}

\item{ruleset}{Ruleset to read.}

\item{as_matrix}{If \code{TRUE} (default) return a \code{matrix}, else a \code{list}.}

\item{ldata}{A \code{matrix} obtained with \code{scenarioBuilder},
or a named list of matrices obtained with \code{scenarioBuilder}, names must be
'l', 'h', 'w', 's', 't', 'r', 'ntc' or 'hl', depending on the series to update.}

\item{series}{Name(s) of the serie(s) to update if \code{ldata} is a single \code{matrix}.}

\item{clusters_areas}{A \code{data.table} with two columns \code{area} and \code{cluster}
to identify area/cluster couple to update for thermal or renewable series.
Default is to read clusters description and update all couples area/cluster.}

\item{links}{Links to use if series is \code{"ntc"}.
Either a simple vector with links described as \verb{"area01\%area02} or a \code{data.table} with two columns \code{from} and \code{to}.
Default is to read existing links and update them all.}
}
\value{
\code{scenarioBuilder} : a \code{matrix}

\code{readScenarioBuilder} : a \code{list} of \code{matrix} or \code{list} according to \code{as_matrix} parameters.
}
\description{
\ifelse{html}{\figure{badge_api_ok.svg}{options: alt='Antares API OK'}}{Antares API: \strong{OK}}

Read, create, update & deduplicate scenario builder.
}
\note{
\code{series = "ntc"} is only available with Antares >= 8.2.0.
\code{series = "hl"} each value must be between 0 and 1.
}
\examples{
\dontrun{

library(antaresRead)
library(antaresEditObject)

# simulation path
setSimulationPath(
  path = "pat/to/simulation",
  simulation = "input"
)

# Create a scenario builder matrix
sbuilder <- scenarioBuilder(
  n_scenario = 51,
  n_mc = 2040,
  areas_rand = c("fr", "be")
)
sbuilder[, 1:6]
dim(sbuilder)

# Create a scenario builder matrix for hydro levels (use case 1)
sbuilder <- scenarioBuilder(
  n_mc = opts$parameters$general$nbyears,
  areas = c("fr", "be"),
  coef_hydro_levels = c(0.1, 0.9)
)

# Create a scenario builder matrix for hydro levels (use case 2)
sbuilder <- scenarioBuilder(
  n_mc = opts$parameters$general$nbyears,
  areas = c("fr", "be"),
  coef_hydro_levels = c(runif(opts$parameters$general$nbyears)
  , runif(opts$parameters$general$nbyears)
  )
)

# Read previous scenario builder
# in a matrix format
prev_sb <- readScenarioBuilder()


# Update scenario builder

# for load serie
updateScenarioBuilder(ldata = sbuilder, series = "load")

# equivalent as
updateScenarioBuilder(ldata = list(l = sbuilder))


# update several series

# same input
sbuilder
updateScenarioBuilder(
  ldata = sbuilder, 
  series = c("load", "hydro", "solar")
)

# different input
updateScenarioBuilder(ldata = list(
  l = load_sb,
  h = hydro_sb,
  s = solar_sb
))

# Deduplicate scenario builder

deduplicateScenarioBuilder()
}
}
