% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createLink.R
\name{createLink}
\alias{createLink}
\title{Create a link between two areas}
\usage{
createLink(
  from,
  to,
  propertiesLink = propertiesLinkOptions(),
  dataLink = NULL,
  overwrite = FALSE,
  opts = antaresRead::simOptions()
)
}
\arguments{
\item{from}{The first area from which to create a link}

\item{to}{The second one}

\item{propertiesLink}{a named list containing the link properties, e.g. hurdles-cost
or transmission-capacities for example. See \code{\link{propertiesLinkOptions}}.}

\item{dataLink}{For Antares v7, a matrix with eight column corresponding to : trans. capacity (direct)
trans. capacity (indirect), hurdles cost (direct), hurdles cost (indirect), impedances, loop flow,
PST min, PST max.
If \code{NULL} (default), a matrix whose rows are equal to \code{1, 1, 0, 0, 0, 0, 0, 0} is set. See Details}

\item{overwrite}{Logical, overwrite the previous between the two areas if exist}

\item{opts}{List of simulation parameters returned by the function
\code{antaresRead::setSimulationPath}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
Create a link between two areas
}
\details{
The eight times-series are:
\itemize{
 \item{\strong{NTC direct}}{ : the upstream-to-downstream capacity, in MW}
 \item{\strong{NTC indirect}}{ : the downstream-to-upstream capacity, in MW}
 \item{\strong{Hurdle cost direct}}{ : an upstream-to-downstream transmission fee, in euro/MWh}
 \item{\strong{Hurdle cost indirect}}{ : a downstream-to-upstream transmission fee, in euro/MWh}
 \item{\strong{Impedances}}{ : virtual impedances that are used in economy simulations to give a
   physical meaning to raw outputs, when no binding constraints have been defined to enforce Kirchhoff's laws.}
 \item{\strong{Loop flow}}{ : amount of power flowing circularly though the grid when all
   "nodes" are perfectly balanced (no import and no export).}
 \item{\strong{PST min}}{ : lower bound of phase-shifting that can be reached by a PST installed on the link, if any.}
 \item{\strong{PST max}}{ : upper bound of phase-shifting that can be reached by a PST installed on the link, if any.}
}
NB: For Antares v7 the eight columns must conform to above order. For Antares v6, only five columns are 
expected, and they must follow this other order: NTC direct, NTC indirect, Impedances, Hurdle cost direct,
Hurdle cost indirect.
}
\note{
In Antares, areas are sorted in alphabetical order to establish links between.
For example, link between "fr" and "be" will appear under "be". 
So the areas are sorted before creating the link between them, and \code{dataLink} is
rearranged to match the new order.
}
\examples{
\dontrun{

library(antaresRead)

# Set simulation path
setSimulationPath(path = "PATH/TO/SIMULATION", simulation = "input")

# Create a link between two areas
createLink(from = "first_area", to  = "second_area")

}
}
