% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createLink.R
\name{createLink}
\alias{createLink}
\title{Create a link between two areas}
\usage{
createLink(from, to, propertiesLink = propertiesLinkOptions(),
  dataLink = NULL, overwrite = FALSE,
  opts = antaresRead::simOptions())
}
\arguments{
\item{from}{The first area from which to create a link}

\item{to}{The second one}

\item{propertiesLink}{a named list containing the link properties, e.g. hurdles-cost
or transmission-capacities for example.}

\item{dataLink}{a matrix with five column corresponding to : trans. capacity (direct)
trans. capacity (indirect), impedances, hurdles cost (direct), hurdles cost (indirect).
If \code{NULL} (default), a matrix whose rows are equal to \code{1, 1, 0, 0, 0} is set. See Details}

\item{overwrite}{Logical, overwrite the previous between the two areas if exist}

\item{opts}{List of simulation parameters returned by the function
\code{antaresRead::setSimulationPath}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
Create a link between two areas
}
\details{
The five times-series are:
\itemize{
 \item{"NTC direct"}{the upstream-to-downstream capacity, in MW}
 \item{"NTC indirect"}{the downstream-to-upstream capacity, in MW}
 \item{"Impedances"}{virtual impedances that are used in economy simulations to give a physical meaning to raw outputs, when no binding constraints have been defined to enforce Kirchhoff's laws.}
 \item{"Hurdle cost direct"}{an upstream-to-downstream transmission fee, in euro/MWh}
 \item{"Hurdle cost indirect"}{a downstream-to-upstream transmission fee, in euro/MWh}
}
}
\note{
In Antares, areas are sorted in alphabetical order to establish links between.
For example, link between "fr" and "be" will appear under "be". 
So the areas are sorted before creating the link between them, and \code{dataLink} is
rearranged to match the new order.
}
\examples{
\dontrun{
createLink(from = "myarea", to  = "myarea2")
}
}
