% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_analysis.R
\name{factor_analysis}
\alias{factor_analysis}
\title{Factor Analysis with Varimax Rotation}
\usage{
factor_analysis(data, hc_points)
}
\arguments{
\item{data}{numeric data}

\item{hc_points}{vector of eigenvalues [designed to use output from horns_curve() function]}
}
\value{
A list containing:
    \enumerate{
      \item \code{fa_loadings}: numerical matrix with the original factor loadings
      \item \code{fa_scores}: numerical matrix with the row scores for each factor
      \item \code{fa_loadings_rotated}: numerical matrix with the varimax rotated factor loadings
      \item \code{fa_scores_rotated}: numerical matrix with the row scores for each varimax rotated factor
      \item \code{num_factors}: numeric vector identifying the number of factors
    }
}
\description{
\code{factor_analysis} reduces the structure of the data by relating the
correlation between variables to a set of factors, using the eigen-decomposition
of the correlation matrix.
}
\examples{

# Perform Factor Analysis with matrix \\code{x}
x <- matrix(rnorm(200*3), ncol = 10)

x \%>\%
  horns_curve() \%>\%
  factor_analysis(x, hc_points = .)

}
\references{
H. F. Kaiser, "The Application of Electronic Computers to Factor Analysis,"
Educational and Psychological Measurement, 1960.
}
\seealso{
\code{\link{horns_curve}} for computing the average eigenvalues used for \code{hc_points} argument
}
