% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_recompose.R
\name{time_recompose}
\alias{time_recompose}
\title{Recompose bands separating anomalies from "normal" observations}
\usage{
time_recompose(data)
}
\arguments{
\item{data}{A \code{tibble} or \code{tbl_time} object that has been
processed with \code{time_decompose()} and \code{anomalize()}.}
}
\value{
Returns a \code{tbl_time} object.
}
\description{
Recompose bands separating anomalies from "normal" observations
}
\details{
The \code{time_recompose()} function is used to generate bands around the
"normal" levels of observed values. The function uses the remainder_l1
and remainder_l2 levels produced during the \code{\link[=anomalize]{anomalize()}} step
and the season and trend/median_spans values from the \code{\link[=time_decompose]{time_decompose()}}
step to reconstruct bands around the normal values.

The following key names are required: observed:remainder from the
\code{time_decompose()} step and remainder_l1 and remainder_l2 from the
\code{anomalize()} step.
}
\examples{

library(dplyr)

data(tidyverse_cran_downloads)

# Basic Usage
tidyverse_cran_downloads \%>\%
    time_decompose(count, method = "stl") \%>\%
    anomalize(remainder, method = "iqr") \%>\%
    time_recompose()


}
\seealso{
Time Series Anomaly Detection Functions (anomaly detection workflow):
\itemize{
\item \code{\link[=time_decompose]{time_decompose()}}
\item \code{\link[=anomalize]{anomalize()}}
}
}
