% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotator.R
\name{annotate}
\alias{annotate}
\title{Create an annotation widget}
\usage{
annotate(
  im,
  resultId = "annot_id",
  brushWidth = 4,
  brushColor = "red",
  opacity = 0.5,
  fill = "grey"
)
}
\arguments{
\item{im}{the input image. If missing, a transparent 800x600 png is used.}

\item{resultId}{the id of the \code{div} in the \code{UI} where the annotation (the drawn polygon) is stored.
Only relevant when the widget is used in shiny. Defaults to "annot_id".}

\item{brushWidth}{default to 3 pixels.}

\item{brushColor}{Any valid CSS color. For example "red", "rgba(255,93,0,1)", or "#1c4564".}

\item{opacity}{default to 0.5.}

\item{fill}{default to 'gray'}
}
\value{
An object generated by \code{\link[htmlwidgets:createWidget]{htmlwidgets::createWidget()}}.
}
\description{
This function creates an annotation using \link{htmlwidgets}.
The widget can be rendered on HTML pages generated from Shiny or
other applications.
}
\examples{
if (interactive()) {
  require(annotator)
  im = system.file("sample_images", "aves", "5.png", package = "annotator")
  annotate(im)
}

}
