% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_analysis.R
\name{compare_summarise_daily}
\alias{compare_summarise_daily}
\title{Compares two animal datasets and calculates daily summary statistics by GPS
GPS, date, lat, long, course, distance, rate, elevation column names should match.}
\usage{
compare_summarise_daily(
  correct,
  candidate,
  use_elev = TRUE,
  export = FALSE,
  out = NULL
)
}
\arguments{
\item{correct}{reference data frame}

\item{candidate}{data frame to be compared to the reference}

\item{use_elev}{logical, whether to include elevation in summary, defaults to true}

\item{export}{logical, whether to export summary to .csv, defaults to False}

\item{out}{desired file name of .csv output summary when export is True}
}
\value{
summary data frame
}
\description{
Compares two animal datasets and calculates daily summary statistics by GPS
GPS, date, lat, long, course, distance, rate, elevation column names should match.
}
\examples{
# Compare and summarise unfiltered demo cows to filtered, grouped by both Date and GPS

compare_summarise_daily(demo_unfiltered_elev, demo_filtered_elev)
}
