% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_analysis.R
\name{compare_summarise_data}
\alias{compare_summarise_data}
\title{Compares two animal data frames and calculates summary statistics. 
GPS, date, lat, long, course, distance, rate, elevation column names should match.}
\usage{
compare_summarise_data(
  correct,
  candidate,
  export = FALSE,
  gps_out = NULL,
  date_out = NULL
)
}
\arguments{
\item{correct}{reference df}

\item{candidate}{df to be compared to the reference}

\item{export}{logical, whether to export summaries to .csv, defaults to False}

\item{gps_out}{desired file name of .csv output summary by GPS collar when export is True}

\item{date_out}{desired file name of .csv output summary by date when export is True}
}
\value{
list containing gps_out and date_out as dfs
}
\description{
Compares two animal data frames and calculates summary statistics. 
GPS, date, lat, long, course, distance, rate, elevation column names should match.
}
\examples{
# Compare and summarise unfiltered demo cows to filtered 
compare_summarise_data(demo_unfiltered_elev, demo_filtered_elev)
}
