% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R,
%   R/core-functions-meta-pipelines.R
\docType{methods}
\name{visualizePipeline}
\alias{visualizePipeline}
\alias{visualizePipeline,BaseAnalysisPipeline-method}
\alias{visualizePipeline,MetaAnalysisPipeline-method}
\title{Visualizes the pipeline as a graph}
\usage{
visualizePipeline(object)

\S4method{visualizePipeline}{BaseAnalysisPipeline}(object)

\S4method{visualizePipeline}{MetaAnalysisPipeline}(object)
}
\arguments{
\item{object}{The \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object}
}
\value{
A graph object which can be printed (or) plotted to visualize the pipeline
}
\description{
Visualizes the pipeline as a graph
}
\details{
Indicates dependencies amongst functions as well as functions for which output
needs to be stored
}
\examples{
\dontrun{
library(analysisPipelines)
pipelineObj <- AnalysisPipeline(input = iris)
pipelineObj \%>>\% univarCatDistPlots(uniCol = "Species",
 priColor = "blue", optionalPlots = 0, storeOutput = T) \%>>\%
visualizePipeline
}
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{updateObject}}
}
\concept{Package core functions}
