% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R
\docType{methods}
\name{updateObject}
\alias{updateObject}
\alias{updateObject,BaseAnalysisPipeline-method}
\title{Update the \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object by adding an operation to the pipeline}
\usage{
updateObject(object, operation, heading = "", parameters, outAsIn = F,
  storeOutput = F)

\S4method{updateObject}{BaseAnalysisPipeline}(object, operation,
  heading = "", parameters, outAsIn = F, storeOutput = F)
}
\arguments{
\item{object}{object that contains input, pipeline, registry and output}

\item{operation}{function name to be updated in tibble}

\item{heading}{heading of that section in report}

\item{parameters}{parameters passed to that function}

\item{outAsIn}{whether to use original input or output from previous function}

\item{storeOutput}{whether the output of this operation is to be stored}
}
\value{
Updated \code{AnalysisPipeline} \code{StreamingAnalysisPipeline} object
}
\description{
Update the \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object by adding an operation to the pipeline
}
\details{
The specified operation along with the heading and parameters is updated in the pipeline slot
      of the  \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object, where the sequence of operations
     to be performed is stored

This method is implemented on the base class as it is a shared functionality types of Analysis Pipelines
which extend this class
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
