% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions-meta-pipelines.R
\docType{methods}
\name{createPipelineInstance}
\alias{createPipelineInstance}
\alias{createPipelineInstance,MetaAnalysisPipeline-method}
\title{Create a Pipeline object from a meta-pipeline}
\usage{
createPipelineInstance(metaPipelineObj, newParams)

\S4method{createPipelineInstance}{MetaAnalysisPipeline}(metaPipelineObj,
  newParams)
}
\arguments{
\item{metaPipelineObj}{A \code{MetaAnalysisPipeline} object}

\item{newParams}{Either a nested named list containing all the functions in the pipeline, their arguments and
corresponding values (OR) an object of class \code{proto} which is a pipeline prototype, with the new values of the arguments
set. Refer the \code{getPipelinePrototype} method.}
}
\value{
A Pipeline object
}
\description{
Create a Pipeline object from a meta-pipeline
}
\details{
This method instantiates a Pipeline object (both \code{AnalysisPipeline} and \code{StreamingAnalysisPipeline}) from
a meta-pipeline as well as an object containing the new set of values for the arguments of all the functions in the pipeline.
}
\examples{
\dontrun{
pipelineObj <- AnalysisPipeline(input = iris)
pipelineObj \%>>\% univarCatDistPlots(uniCol = "Species") -> pipelineObj
pipelineObj \%>>\% exportAsMetaPipeline -> exportedMetaPipeline
exportedMetaPipeline \%>>\%
createPipelineInstance(newParams = exportedMetaPipeline \%>>\%
 getPipelinePrototype)
}
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setInput}}, \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
