% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.forms.R
\name{amber.forms}
\alias{amber.forms}
\title{Get the forms}
\usage{
amber.forms(
  amber,
  study = NULL,
  query = list(),
  skip = 0,
  limit = 100,
  df = TRUE
)
}
\arguments{
\item{amber}{An Amber object}

\item{study}{Study name or identifier, optional}

\item{query}{The search query}

\item{skip}{Number of items to skip}

\item{limit}{Max number of items}

\item{df}{Return a data.frame (default is TRUE)}
}
\value{
A data.frame (or a named list of raw results when 'df' is FALSE)
}
\description{
Get the forms
}
\examples{
\dontrun{
a <- amber.login("https://amber-demo.obiba.org")
amber.forms(a)
amber.forms(a, study="Trauma Registry", skip = 0, limit = 10)
amber.logout(a)
}
}
\seealso{
Other studies functions: 
\code{\link{amber.campaign}()},
\code{\link{amber.campaigns}()},
\code{\link{amber.case_report_export}()},
\code{\link{amber.case_report_form}()},
\code{\link{amber.case_report_forms}()},
\code{\link{amber.case_reports}()},
\code{\link{amber.form}()},
\code{\link{amber.form_revision}()},
\code{\link{amber.form_revisions}()},
\code{\link{amber.interview_design}()},
\code{\link{amber.interview_designs}()},
\code{\link{amber.interview_export}()},
\code{\link{amber.interviews}()},
\code{\link{amber.participant}()},
\code{\link{amber.participants}()},
\code{\link{amber.studies}()},
\code{\link{amber.study}()}
}
\concept{studies functions}
