% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_amanida.R
\name{compute_amanida}
\alias{compute_amanida}
\title{Combine statistical results and compute vote-counting}
\usage{
compute_amanida(datafile)
}
\arguments{
\item{datafile}{data imported using amanida_read function}
}
\value{
METAtable S4 object with p-value combined, fold-change combined and vote-counting for each compound
}
\description{
\code{compute_amanida} Combines for the same entry or metabolite the statistical values of p-value and fold-change. Also is computed a vote-counting for each compound.
}
\details{
Entries corresponding to metabolites are combined as follows:
\itemize{
\item P-values are combined using Fisher method weighted by N and gamma distribution
\item Fold-change are combined by weighted mean. Transformation works with fold-change transformed to log scale with base 2.
}

Vote-counting is computed based on votes. Punctuation of entries is based on trend, up-regulation gives 1, down-regulation give -1 and equal behavior gives 0. Total sum is divided then by the total number of entries on each compound.
}
\examples{
data("sample_data")

compute_amanida(sample_data)

}
