% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recur-on-position.R
\name{recur_on_position}
\alias{recur_on_position}
\title{Recur on a position within a frequency}
\usage{
recur_on_position(x, n)
}
\arguments{
\item{x}{\verb{[rrule]}

A recurrence rule.}

\item{n}{\verb{[integer]}

The positions to select within an intrafrequency set. Negative numbers
select from the end of the set.}
}
\value{
An updated rrule.
}
\description{
\code{recur_on_position()} let's you have fine tuned control over which element
of the set to select \emph{within} the base frequency.
}
\examples{
library(lubridate, warn.conflicts = FALSE)

start <- "1999-01-01"
end <- "1999-05-01"

# You might want the last day of the month that is either a
# Sunday or a Monday, but you don't want to return both.
# This would return both:
on_last_monday_and_sunday <- monthly() \%>\%
  recur_on_wday(c("Monday", "Sunday"), -1)

alma_search(start, end, on_last_monday_and_sunday)

# To return just the last one, you would select the last value in
# the set, which is computed on a per month basis
on_very_last_monday_or_sunday <- on_last_monday_and_sunday \%>\%
  recur_on_position(-1)

alma_search(start, end, on_very_last_monday_or_sunday)

wday(alma_search(start, end, on_very_last_monday_or_sunday), label = TRUE)

}
