% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfConversions.R
\name{shapeMapToPolygonSf}
\alias{shapeMapToPolygonSf}
\title{ShapeMap to sf Polygon map}
\usage{
shapeMapToPolygonSf(shapeMap)
}
\arguments{
\item{shapeMap}{A ShapeMap}
}
\value{
A new sf Polygon map
}
\description{
Convert a ShapeMap to an sf Polygon map
}
\examples{
mifFile <- system.file(
    "extdata", "testdata", "simple",
    "simple_interior.mif",
    package = "alcyon"
  )
  sfMap <- st_read(mifFile,
    geometry_column = 1L, quiet = TRUE
  )
  shapeMap <- as(sfMap[, vector()], "ShapeMap")
isovistMap <- isovist(
  shapeMap,
  x = c(3.01, 1.3),
  y = c(6.70, 5.2),
  angle = 0.01,
  viewAngle = 3.14,
  FALSE
)
shapeMapToPolygonSf(isovistMap)
}
