% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_log.R
\name{write_log}
\alias{write_log}
\title{Write log}
\usage{
write_log(
  log_file,
  value_top = 0,
  total_top = 1,
  message_top = NA,
  value_middle = 0,
  total_middle = 1,
  message_middle = NA,
  value_bottom = 0,
  total_bottom = 1,
  message_bottom = NA,
  last_log = NULL,
  write_interval = 2
)
}
\arguments{
\item{log_file}{\code{string} Path to the file where the log should be saved and updated.}

\item{value_top}{\code{double} Current value for the top process.}

\item{total_top}{\code{double} Maximal value for the top process.}

\item{message_top}{\code{string} Message describing the current state of the top process.}

\item{value_middle}{\code{double} Current value for the middle process.}

\item{total_middle}{\code{double} Maximal value for the middle process.}

\item{message_middle}{\code{string} Message describing the current state of the middle process.}

\item{value_bottom}{\code{double} Current value for the bottom process.}

\item{total_bottom}{\code{double} Maximal value for the bottom process.}

\item{message_bottom}{\code{string} Message describing the current state of the bottom process.}

\item{last_log}{\code{POSIXct} Time when the last log was created. If there is no log file set this value to \code{NULL}.}

\item{write_interval}{\code{int} Time in seconds. This time must be past before a new log is created.}
}
\value{
This function writes a log file to the given location. If \code{log_file} is \code{NULL} the function will not try to
write a log file.

If \code{log_file} is a valid path to a file the function will write a log if the time specified by
\code{write_interval} has passed. In addition the function will return an object of class \code{POSIXct} describing the time
when the log file was successfully updated. If the initial attempt for writing log fails the function returns the
value of \code{last_log} which is \code{NULL} by default.
}
\description{
Function for writing a log file from R containing three rows and three columns. The log file can report
the current status of maximal three processes. The first row describes the top process. The second row describes
the status of the process within the top process. The third row can be used to describe the status of a process
within the middle process.

The log can be read with \link{read_log}.
}
\seealso{
Other Utils Log Developers: 
\code{\link{cat_message}()},
\code{\link{clean_pytorch_log_transformers}()},
\code{\link{output_message}()},
\code{\link{print_message}()},
\code{\link{read_log}()},
\code{\link{read_loss_log}()},
\code{\link{reset_log}()},
\code{\link{reset_loss_log}()}
}
\concept{Utils Log Developers}
